<?php
// upload files
$folderPath = "hr_test/";

if (isset($_FILES['files'])) {
    $fileCount = count($_FILES['files']['name']);

    for ($i = 0; $i < $fileCount; $i++) {
        $file = $_FILES['files'];
        $fileName = $file['name'][$i];
        $fileTmpPath = $file['tmp_name'][$i];
        $fileType = $file['type'][$i];
        $fileError = $file['error'][$i];

        // Check if the file upload encountered any error
        if ($fileError !== UPLOAD_ERR_OK) {
            $response[] = array(
                'success' => false,
                'msg' => "Error uploading file: $fileName. Error code: $fileError",
                'status' => "unsuccess",
            );
            continue;
        }

        if (empty($fileName)) {
            $response[] = array(
                'success' => false,
                'msg' => "Error uploading file: Empty filename",
                'status' => "unsuccess",
            );
            continue;
        }

        // Add any additional filename validation checks here

        $destination = $folderPath . $fileName;

        if (move_uploaded_file($fileTmpPath, $destination)) {
            $response[] = array(
                'success' => true,
                'msg' => "Success uploading file: $fileName",
                'status' => "success",
            );
        } else {
            $response[] = array(
                'success' => false,
                'msg' => "Error uploading file: $fileName",
                'status' => "unsuccess",
            );
        }
    }

    echo json_encode($response, JSON_UNESCAPED_UNICODE);
}
?>