<!DOCTYPE html>
<html>
<head>
  <title>Image Text Extraction</title>
  <script src="https://cdn.jsdelivr.net/npm/tesseract.js@2.2.2"></script>
</head>
<body>
  <input type="file" id="image-input" accept="image/*" />
  <button onclick="convertImageToText()">Convert</button>
  <div id="result"></div>

  <script>
    async function convertImageToText() {
      const fileInput = document.getElementById('image-input');
      const file = fileInput.files[0];

      if (!file) {
        alert('Please select an image file.');
        return;
      }

      await Tesseract.load();
      const { data: { text } } = await Tesseract.recognize(file, 'eng');
      document.getElementById('result').textContent = text;
    }
  </script>
</body>
</html>