<!DOCTYPE html>
<html>
<head>
  <title>Table Search</title>
  <style>
    table {
      border-collapse: collapse;
    }

    th, td {
      border: 1px solid black;
      padding: 8px;
    }
  </style>
</head>
<body>
  <h1>Table Search</h1>

  <input id="searchInput" type="text" placeholder="Search by specific td">

  <table id="myTable">
    <tr>
      <th>First Name</th>
      <th>Last Name</th>
      <th>Email</th>
    </tr>
    <tr>
      <td>John</td>
      <td>Doe</td>
      <td>john@example.com</td>
    </tr>
    <tr>
      <td>Jane</td>
      <td>Smith</td>
      <td>jane@example.com</td>
    </tr>
    <tr>
      <td>Bob</td>
      <td>Johnson</td>
      <td>bob@example.com</td>
    </tr>
  </table>

  <script>
    const searchInput = document.querySelector('#searchInput');
    const table = document.querySelector('#myTable');
    const rows = table.getElementsByTagName('tr');

    searchInput.addEventListener('input', function() {
      const searchText = searchInput.value.toLowerCase();

      Array.from(rows).forEach(function(row) {
        const td = row.getElementsByTagName('td')[1]; // Index 1 refers to the second <td> element in each row

        if (td) {
          const tdText = td.textContent || td.innerText;

          if (tdText.toLowerCase().indexOf(searchText) !== -1) {
            row.style.display = '';
          } else {
            row.style.display = 'none';
          }
        }
      });
    });
  </script>
</body>
</html>